/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.collect.AbstractIterator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IBoxExpansion;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class BoxAOEIterator
implements IAreaOfEffectIterator {
    public static final Loader LOADER = new Loader();
    private final BoxSize base;
    private final BoxSize[] expansions;
    private final IBoxExpansion direction;

    public static Builder builder(int width, int height, int depth) {
        return new Builder(new BoxSize(width, height, depth));
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends IAreaOfEffectIterator> getLoader() {
        return LOADER;
    }

    private BoxSize sizeFor(int level) {
        if (level == 0 || this.expansions.length == 0) {
            return this.base;
        }
        int width = this.base.width;
        int height = this.base.height;
        int depth = this.base.depth;
        if (level >= this.expansions.length) {
            int cycles = level / this.expansions.length;
            for (BoxSize expansion : this.expansions) {
                width += expansion.width * cycles;
                height += expansion.height * cycles;
                depth += expansion.depth * cycles;
            }
        }
        int remainder = level % this.expansions.length;
        for (int i = 0; i < remainder; ++i) {
            BoxSize expansion = this.expansions[i];
            width += expansion.width;
            height += expansion.height;
            depth += expansion.depth;
        }
        return new BoxSize(width, height, depth);
    }

    @Override
    public Iterable<class_2338> getBlocks(IToolStackView tool, class_1799 stack, class_1657 player, class_2680 state, class_1937 world, class_2338 origin, class_2350 sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return BoxAOEIterator.calculate(tool, stack, world, player, origin, sideHit, this.sizeFor(expanded), this.direction, matchType);
    }

    public static Iterable<class_2338> calculate(IToolStackView tool, class_1799 stack, class_1937 world, class_1657 player, class_2338 origin, class_2350 sideHit, BoxSize extraSize, IBoxExpansion expansionDirection, IAreaOfEffectIterator.AOEMatchType matchType) {
        if (extraSize.isZero()) {
            return Collections.emptyList();
        }
        IBoxExpansion.ExpansionDirections expansion = expansionDirection.getDirections(player, sideHit);
        Predicate<class_2338> posPredicate = IAreaOfEffectIterator.defaultBlockPredicate(tool, stack, world, origin, matchType);
        return () -> new RectangleIterator(origin, expansion.width(), extraSize.width, expansion.height(), extraSize.height, expansion.traverseDown(), expansion.depth(), extraSize.depth, posPredicate);
    }

    protected BoxAOEIterator(BoxSize base, BoxSize[] expansions, IBoxExpansion direction) {
        this.base = base;
        this.expansions = expansions;
        this.direction = direction;
    }

    public static class Builder {
        private final BoxSize base;
        @Nonnull
        private IBoxExpansion direction = IBoxExpansion.SIDE_HIT;
        private final List<BoxSize> expansions = new ArrayList<BoxSize>();

        public Builder addExpansion(int width, int height, int depth) {
            this.expansions.add(new BoxSize(width, height, depth));
            return this;
        }

        public Builder addWidth(int width) {
            return this.addExpansion(width, 0, 0);
        }

        public Builder addHeight(int height) {
            return this.addExpansion(0, height, 0);
        }

        public Builder addDepth(int depth) {
            return this.addExpansion(0, 0, depth);
        }

        public BoxAOEIterator build() {
            return new BoxAOEIterator(this.base, this.expansions.toArray(new BoxSize[0]), this.direction);
        }

        public Builder(BoxSize base) {
            this.base = base;
        }

        public Builder direction(@Nonnull IBoxExpansion direction) {
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            this.direction = direction;
            return this;
        }
    }

    private record BoxSize(int width, int height, int depth) {
        public boolean isZero() {
            return this.width == 0 && this.height == 0 && this.depth == 0;
        }

        public JsonObject toJson() {
            JsonObject object = new JsonObject();
            if (this.width > 0) {
                object.addProperty("width", (Number)this.width);
            }
            if (this.height > 0) {
                object.addProperty("height", (Number)this.height);
            }
            if (this.depth > 0) {
                object.addProperty("depth", (Number)this.depth);
            }
            return object;
        }

        public void toNetwork(class_2540 buf) {
            buf.method_10804(this.width);
            buf.method_10804(this.height);
            buf.method_10804(this.depth);
        }

        public static BoxSize fromJson(JsonObject json) {
            return new BoxSize(JsonUtils.getIntMin(json, "width", 0), JsonUtils.getIntMin(json, "height", 0), JsonUtils.getIntMin(json, "depth", 0));
        }

        public static BoxSize fromNetwork(class_2540 buffer) {
            return new BoxSize(buffer.method_10816(), buffer.method_10816(), buffer.method_10816());
        }
    }

    private static class Loader
    implements GenericLoaderRegistry.IGenericLoader<BoxAOEIterator> {
        private Loader() {
        }

        @Override
        public BoxAOEIterator deserialize(JsonObject json) {
            BoxSize base = BoxSize.fromJson(class_3518.method_15296((JsonObject)json, (String)"bonus"));
            BoxSize[] expansions = json.has("expansions") ? JsonHelper.parseList(json, "expansions", BoxSize::fromJson).toArray(new BoxSize[0]) : new BoxSize[]{};
            IBoxExpansion direction = IBoxExpansion.REGISTRY.deserialize(json, "expansion_direction");
            return new BoxAOEIterator(base, expansions, direction);
        }

        @Override
        public BoxAOEIterator fromNetwork(class_2540 buffer) {
            BoxSize base = BoxSize.fromNetwork(buffer);
            int count = buffer.method_10816();
            BoxSize[] expansions = new BoxSize[count];
            for (int i = 0; i < count; ++i) {
                expansions[i] = BoxSize.fromNetwork(buffer);
            }
            IBoxExpansion direction = IBoxExpansion.REGISTRY.fromNetwork(buffer);
            return new BoxAOEIterator(base, expansions, direction);
        }

        @Override
        public void serialize(BoxAOEIterator object, JsonObject json) {
            json.add("bonus", (JsonElement)object.base.toJson());
            if (object.expansions.length > 0) {
                JsonArray expansions = new JsonArray();
                for (BoxSize box : object.expansions) {
                    expansions.add((JsonElement)box.toJson());
                }
                json.add("expansions", (JsonElement)expansions);
                json.addProperty("expansion_direction", IBoxExpansion.REGISTRY.getKey(object.direction).toString());
            }
        }

        @Override
        public void toNetwork(BoxAOEIterator object, class_2540 buffer) {
            object.base.toNetwork(buffer);
            buffer.method_10804(object.expansions.length);
            for (BoxSize box : object.expansions) {
                box.toNetwork(buffer);
            }
            IBoxExpansion.REGISTRY.toNetwork(object.direction, buffer);
        }
    }

    public static class RectangleIterator
    extends AbstractIterator<class_2338> {
        private final class_2350 widthDir;
        private final class_2350 heightDir;
        private final class_2350 depthDir;
        private final int maxWidth;
        private final int maxHeight;
        private final int maxDepth;
        private int currentWidth = 0;
        private int currentHeight = 0;
        private int currentDepth = 0;
        protected final class_2338 origin;
        protected final class_2338.class_2339 mutablePos;
        protected final Predicate<class_2338> posPredicate;
        protected int lastX;
        protected int lastY;
        protected int lastZ;

        public RectangleIterator(class_2338 origin, class_2350 widthDir, int extraWidth, class_2350 heightDir, int extraHeight, boolean traverseDown, class_2350 depthDir, int extraDepth, Predicate<class_2338> posPredicate) {
            this.origin = origin;
            this.widthDir = widthDir;
            this.heightDir = heightDir;
            this.depthDir = depthDir;
            this.maxWidth = extraWidth * 2;
            this.maxHeight = traverseDown ? extraHeight * 2 : extraHeight;
            this.maxDepth = extraDepth;
            this.mutablePos = new class_2338.class_2339(origin.method_10263(), origin.method_10264(), origin.method_10260());
            this.posPredicate = posPredicate;
            if (extraWidth > 0) {
                --this.currentWidth;
            } else if (extraHeight > 0) {
                --this.currentHeight;
            }
            this.mutablePos.method_10104(widthDir, -extraWidth + this.currentWidth);
            if (traverseDown) {
                this.mutablePos.method_10104(heightDir, -extraHeight + this.currentHeight);
            } else if (this.currentHeight != 0) {
                this.mutablePos.method_10104(heightDir, this.currentHeight);
            }
            this.lastX = this.mutablePos.method_10263();
            this.lastY = this.mutablePos.method_10264();
            this.lastZ = this.mutablePos.method_10260();
        }

        protected boolean incrementPosition() {
            if (this.currentWidth == this.maxWidth) {
                if (this.currentHeight == this.maxHeight) {
                    if (this.currentDepth == this.maxDepth) {
                        return false;
                    }
                    ++this.currentDepth;
                    this.mutablePos.method_10098(this.depthDir);
                    this.currentHeight = 0;
                    this.mutablePos.method_10104(this.heightDir, -this.maxHeight);
                } else {
                    ++this.currentHeight;
                    this.mutablePos.method_10098(this.heightDir);
                }
                this.currentWidth = 0;
                this.mutablePos.method_10104(this.widthDir, -this.maxWidth);
            } else {
                ++this.currentWidth;
                this.mutablePos.method_10098(this.widthDir);
            }
            return true;
        }

        protected class_2338 computeNext() {
            this.mutablePos.method_10103(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || !this.posPredicate.test((class_2338)this.mutablePos)) continue;
                this.lastX = this.mutablePos.method_10263();
                this.lastY = this.mutablePos.method_10264();
                this.lastZ = this.mutablePos.method_10260();
                return this.mutablePos;
            }
            return (class_2338)this.endOfData();
        }
    }
}

